/*
 * capturing from UVC cam
 * requires: libjpeg-dev
 * build: gcc -std=c99 piano_v5.c -ljpeg -o piano_v5
 */

#include <unistd.h> 
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
 
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <asm/types.h>
#include <linux/videodev2.h>
 
#include <sys/time.h>
#include <sys/types.h>
 
#include <jpeglib.h>
#include <inttypes.h> 

#include "vga_led.h"
#include <sys/stat.h>

#include <linux/types.h>

#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
 
void changemode(int dir)
{
  static struct termios oldt, newt;
 
  if ( dir == 1 )
  {
    tcgetattr( STDIN_FILENO, &oldt);
    newt = oldt;
    newt.c_lflag &= ~( ICANON | ECHO );
    tcsetattr( STDIN_FILENO, TCSANOW, &newt);
  }
  else
    tcsetattr( STDIN_FILENO, TCSANOW, &oldt);
}
 
int kbhit (void)
{
  struct timeval tv;
  fd_set rdfs;
 
  tv.tv_sec = 0;
  tv.tv_usec = 0;
 
  FD_ZERO(&rdfs);
  FD_SET (STDIN_FILENO, &rdfs);
 
  select(STDIN_FILENO+1, &rdfs, NULL, NULL, &tv);
  return FD_ISSET(STDIN_FILENO, &rdfs);
 
}

int vga_led_fd;

/* Write the contents of the array to the display */
void write_segments(const unsigned char segs[1063])
{
	vga_led_arg_t vla;
	__u32 i;
	for (i = 1 ; i < VGA_LED_DIGITS ; i++) {
		vla.digit = i;
		vla.segments = segs[i];
		if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
			perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
			return;
		}
	}
}

void quit(const char * msg)
{
	fprintf(stderr, "[%s] %d: %s\n", msg, errno, strerror(errno));
	exit(EXIT_FAILURE);
}
 
int xioctl(int fd, int request, void* arg)
{
	for (int i = 0; i < 100; i++) {
		int r = ioctl(fd, request, arg);
		if (r != -1 || errno != EINTR) return r;
	}
	return -1;
}
 
typedef struct {
	uint8_t* start;
	size_t length;
} buffer_t;
 
typedef struct {
	int fd;
	uint32_t width;
	uint32_t height;
	size_t buffer_count;
	buffer_t* buffers;
	buffer_t head;
} camera_t;

 
camera_t* camera_open(const char * device, uint32_t width, uint32_t height)
{
	int fd = open(device, O_RDWR | O_NONBLOCK, 0);
	if (fd == -1) quit("open");
	camera_t* camera = malloc(sizeof (camera_t));
	camera->fd = fd;
	camera->width = width;
	camera->height = height;
	camera->buffer_count = 0;
	camera->buffers = NULL;
	camera->head.length = 0;
	camera->head.start = NULL;
	return camera;
}
 
void camera_init(camera_t* camera)
{
	struct v4l2_capability cap;
	if (xioctl(camera->fd, VIDIOC_QUERYCAP, &cap) == -1) quit("VIDIOC_QUERYCAP");
	if (!(cap.capabilities & V4L2_CAP_VIDEO_CAPTURE)) quit("no capture");
	if (!(cap.capabilities & V4L2_CAP_STREAMING)) quit("no streaming");
	struct v4l2_cropcap cropcap;
	memset(&cropcap, 0, sizeof cropcap);
	cropcap.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	if (xioctl(camera->fd, VIDIOC_CROPCAP, &cropcap) == 0) {
		struct v4l2_crop crop;
		crop.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		crop.c = cropcap.defrect;
		if (xioctl(camera->fd, VIDIOC_S_CROP, &crop) == -1) {
		}
	}
	struct v4l2_format format;
	memset(&format, 0, sizeof format);
	format.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	format.fmt.pix.width = camera->width;
	format.fmt.pix.height = camera->height;
	format.fmt.pix.pixelformat = V4L2_PIX_FMT_YUYV;
	format.fmt.pix.field = V4L2_FIELD_NONE;
	if (xioctl(camera->fd, VIDIOC_S_FMT, &format) == -1) quit("VIDIOC_S_FMT");
	struct v4l2_requestbuffers req;
	memset(&req, 0, sizeof req);
	req.count = 4;
	req.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	req.memory = V4L2_MEMORY_MMAP;
	if (xioctl(camera->fd, VIDIOC_REQBUFS, &req) == -1) quit("VIDIOC_REQBUFS");
	camera->buffer_count = req.count;
	camera->buffers = calloc(req.count, sizeof (buffer_t));
	size_t buf_max = 0;
	for (size_t i = 0; i < camera->buffer_count; i++) {
		struct v4l2_buffer buf;
		memset(&buf, 0, sizeof buf);
		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		buf.memory = V4L2_MEMORY_MMAP;
		buf.index = i;
		if (xioctl(camera->fd, VIDIOC_QUERYBUF, &buf) == -1) quit("VIDIOC_QUERYBUF");
		if (buf.length > buf_max) buf_max = buf.length;
		camera->buffers[i].length = buf.length;
		camera->buffers[i].start =  mmap(NULL, buf.length, PROT_READ | PROT_WRITE, MAP_SHARED, camera->fd, buf.m.offset);
		if (camera->buffers[i].start == MAP_FAILED) quit("mmap");
	}
	camera->head.start = malloc(buf_max);
}
 
 
void camera_start(camera_t* camera)
{
	for (size_t i = 0; i < camera->buffer_count; i++) {
		struct v4l2_buffer buf;
		memset(&buf, 0, sizeof buf);
		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		buf.memory = V4L2_MEMORY_MMAP;
		buf.index = i;
		if (xioctl(camera->fd, VIDIOC_QBUF, &buf) == -1) quit("VIDIOC_QBUF");
	}
	enum v4l2_buf_type type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	if (xioctl(camera->fd, VIDIOC_STREAMON, &type) == -1) quit("VIDIOC_STREAMON");
}
 
void camera_stop(camera_t* camera)
{
	enum v4l2_buf_type type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	if (xioctl(camera->fd, VIDIOC_STREAMOFF, &type) == -1) quit("VIDIOC_STREAMOFF");
}
 
void camera_finish(camera_t* camera)
{
	for (size_t i = 0; i < camera->buffer_count; i++) {
		munmap(camera->buffers[i].start, camera->buffers[i].length);
	}
	free(camera->buffers);
	camera->buffer_count = 0;
	camera->buffers = NULL;
	free(camera->head.start);
	camera->head.length = 0;
	camera->head.start = NULL;
}
 
void camera_close(camera_t* camera)
{
	if (close(camera->fd) == -1) quit("close");
	free(camera);
}
 
 
int camera_capture(camera_t* camera)
{
	struct v4l2_buffer buf;
	memset(&buf, 0, sizeof buf);
	buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	buf.memory = V4L2_MEMORY_MMAP;
	if (xioctl(camera->fd, VIDIOC_DQBUF, &buf) == -1) return FALSE;
	memcpy(camera->head.start, camera->buffers[buf.index].start, buf.bytesused);
	camera->head.length = buf.bytesused;
	if (xioctl(camera->fd, VIDIOC_QBUF, &buf) == -1) return FALSE;
	return TRUE;
}
 
int camera_frame(camera_t* camera, struct timeval timeout) {
	fd_set fds;
	FD_ZERO(&fds);
	FD_SET(camera->fd, &fds);
	int r = select(camera->fd + 1, &fds, 0, 0, &timeout);
	if (r == -1) quit("select");
	if (r == 0) return FALSE;
	return camera_capture(camera);
}
 
void jpeg(FILE* dest, uint8_t* rgb, uint32_t width, uint32_t height, int quality)
{
	JSAMPARRAY image;
	image = calloc(height, sizeof (JSAMPROW));
	for (size_t i = 0; i < height; i++) {
		image[i] = calloc(width * 3, sizeof (JSAMPLE));
		for (size_t j = 0; j < width; j++) {
			image[i][j * 3 + 0] = rgb[(i * width + j) * 3 + 0];
			image[i][j * 3 + 1] = rgb[(i * width + j) * 3 + 1];
			image[i][j * 3 + 2] = rgb[(i * width + j) * 3 + 2];
		}
	}
	struct jpeg_compress_struct compress;
	struct jpeg_error_mgr error;
	compress.err = jpeg_std_error(&error);
	jpeg_create_compress(&compress);
	jpeg_stdio_dest(&compress, dest);
	compress.image_width = width;
	compress.image_height = height;
	compress.input_components = 3;
	compress.in_color_space = JCS_RGB;
	jpeg_set_defaults(&compress);
	jpeg_set_quality(&compress, quality, TRUE);
	jpeg_start_compress(&compress, TRUE);
	jpeg_write_scanlines(&compress, image, height);
	jpeg_finish_compress(&compress);
	jpeg_destroy_compress(&compress);
	for (size_t i = 0; i < height; i++) {
		free(image[i]);
	}
	free(image);
}
 
int minmax(int min, int v, int max)
{
	return (v < min) ? min : (max < v) ? max : v;
}

uint8_t *disrgb(uint8_t* rgb, uint32_t width, uint32_t height)
{       
	int count, upline, downline, up, down;
	int blackline_begin, blackline_end, whiteline_begin, whiteline_end;
	int whitelinesum, blacklinesum;
	int bitcount = 0;
	uint8_t* baseline = calloc(width * 3, sizeof (uint8_t));
	upline = 0;
	downline = 0;
	up = 0;
	down = 0;
	count = 0;
	blackline_begin = 1;
	whiteline_end = 1;

	for (size_t i = 0; i < width * 3; i ++) {	
		baseline[i] = 0;
	}

	for (size_t i = 114; i < 209; i += 2) {
		for (size_t j = 0; j < width * 3; j += 6) {
			size_t index = i * width * 3 + 1053 - j;
			if ((rgb[index] > rgb[index+2])) {
				if (bitcount == 0) baseline[count] += 1; 
				else if (bitcount == 1) baseline[count] += 2; 
				else if (bitcount == 2) baseline[count] += 4; 
				else if (bitcount == 3) baseline[count] += 8; 
				else if (bitcount == 4) baseline[count] += 16; 
				else if (bitcount == 5) baseline[count] += 32; 
				else if (bitcount == 6) baseline[count] += 64; 
				else baseline[count] += 128; 
			}
			if (bitcount == 7) {
				bitcount = 0;
				count += 1;
			}
			else bitcount += 1;
		}
	}

	for (size_t i = 114; i < 209; i += 2) {
		count = 0;
	    for (size_t j = 0; j < width * 3; j += 9) {
		    size_t index = i * width * 3 + 1053 - j;
			if (rgb[index] > rgb[index+2]) {
				count += 1;
			}
	    }
	    if (count > width * 3 / 9 * 0.8) {
			count = 2;
			if (up == 0) up = i;
		}
	    else {
	            count = 0;
	            if (down == 0 && up != 0) down = i;
        	}
	}

	baseline[792] = (up + down) / 2 /2;
	baseline[793] = (up + down) / 2 /2;	
	blacklinesum = (up + down) / 2 - (down - up) / 3;
	whitelinesum = (up + down) / 2 + (down - up) / 3;

	baseline[794] = blacklinesum / 2;
	baseline[795] = blacklinesum / 2;
	baseline[796] = whitelinesum / 2;
	baseline[797] = whitelinesum / 2;
	//printf("Base line is: %d. From %d to %d.\n", baseline[792] + baseline[793], up, down);
	//printf("black line is: %d.\n", blacklinesum);
	//printf("white line is: %d.\n", whitelinesum);
	//printf("\n\n");
	return baseline;
}

uint8_t *finger_detection(uint8_t* rgb, uint32_t width, uint32_t height, int captureline)
{
	int finger_count[5], allbutton;
	allbutton = 0;
	uint8_t* finger_position = calloc(6, sizeof (uint8_t));
	int finger_detect[1056];
	for (size_t i = 0; i < 6; i++) finger_count[i] = 0;
	for (size_t i = 0; i < width * 3; i += 3) {
		size_t index = (captureline + 1) * width * 3 - i;
                if ((rgb[index - 2] > 130) & (rgb[index - 1] > 130)) {
			finger_detect[i] = 1;
			allbutton++;
		}
		else
			finger_detect[i] = 0;
		if ((i >= 39 * 3) & (i < 94 * 3) & (finger_detect[i] == 1)) finger_count[0]++;
		else if ((i >= 94 * 3) & (i < 149 * 3) & (finger_detect[i] == 1)) finger_count[1]++;
		else if ((i >= 149 * 3) & (i < 204 * 3) & (finger_detect[i] == 1)) finger_count[2]++;
		else if ((i >= 204 * 3) & (i < 259 * 3) & (finger_detect[i] == 1)) finger_count[3]++;
		else if ((i >= 259 * 3) & (i < 314 * 3) & (finger_detect[i] == 1)) finger_count[4]++;
	}
	for (size_t i = 0; i < 5; i++) {
		if (finger_count[i] > 8) {
			finger_position[i] = 1;
			//printf("Button %d is pressed!\n", i);
		}
		else finger_position[i] = 0;
	}
	finger_position[5] = 0;
	if (allbutton > 300) finger_position[5] = 1;
	//printf("%d is pressed!\n", finger_position[5]);
	return finger_position;
}

uint8_t* color(uint8_t* rgb, uint32_t width, uint32_t height, int baseline, int blackline, int whiteline)
{
	double whitevalue = 255, blackvalue = 0, pixelvalue = 0, uppervalue = 255;
	double rate;
        blackline = blackline * width * 3;
	whiteline = whiteline * width * 3;
	baseline = baseline * width *3;
	for (size_t i = 0; i < width * 3; i++)
	{	
		whitevalue = rgb[whiteline + i];
		blackvalue = rgb[blackline + i];
		pixelvalue = rgb[baseline + i];
		uppervalue = whitevalue - blackvalue;
		rate = 255 / uppervalue;
		rgb[baseline + i] = minmax(0, (int)((pixelvalue - blackvalue) * rate), 255);
	}
	return rgb;
}
 
uint8_t* yuyv2rgb(uint8_t* yuyv, uint32_t width, uint32_t height)
{
	uint8_t* rgb = calloc(width * height * 3, sizeof (uint8_t));
	for (size_t i = 0; i < height; i++) {
		for (size_t j = 0; j < width; j += 2) {
			size_t index = i * width + j;
			int y0 = yuyv[index * 2 + 0]-0;
			int u = yuyv[index * 2 + 1] - 148;
			int y1 = yuyv[index * 2 + 2]-0;
			int v = yuyv[index * 2 + 3] - 128;
			rgb[index * 3 + 2] = minmax(0, y0 + ((359 * v) >> 8), 255);
			rgb[index * 3 + 1] = minmax(0, y0 - ((88 * v + 183 * u) >> 8), 255);
			rgb[index * 3 + 0] = minmax(0, y0 + ((454 * u) >> 8), 255);
			rgb[index * 3 + 5] = minmax(0, y1 + ((359 * v) >> 8), 255);
			rgb[index * 3 + 4] = minmax(0, y1 - ((88 * v + 183 * u) >> 8), 255);
			rgb[index * 3 + 3] = minmax(0, y1 + ((454 * u) >> 8), 255);
		} 
	}
	return rgb;
}


uint8_t* coloryuyv2rgb(uint8_t* yuyv, uint8_t* black, uint8_t* white, uint32_t width, int capture)
{
	double whitevalue = 255, blackvalue = 0, pixelvalue = 0, uppervalue = 255;
	double rate;
	uint8_t* rgb = calloc(width * 3, sizeof (uint8_t));
	for (size_t i = 0; i < width; i += 2) {
		size_t index = capture * width + i;
		int y0 = yuyv[index * 2 + 0]-0;
		int u = yuyv[index * 2 + 1] - 148;
		int y1 = yuyv[index * 2 + 2]-0;
		int v = yuyv[index * 2 + 3] - 128;
		rgb[i * 3 + 2] = minmax(0, y0 + ((359 * v) >> 8), 255);
		rgb[i * 3 + 1] = minmax(0, y0 - ((88 * v + 183 * u) >> 8), 255);
		rgb[i * 3 + 0] = minmax(0, y0 + ((454 * u) >> 8), 255);
		rgb[i * 3 + 5] = minmax(0, y1 + ((359 * v) >> 8), 255);
		rgb[i * 3 + 4] = minmax(0, y1 - ((88 * v + 183 * u) >> 8), 255);
		rgb[i * 3 + 3] = minmax(0, y1 + ((454 * u) >> 8), 255);
	}
	for (size_t i = 0; i < width * 3; i++)
	{	
		whitevalue = white[i];
		blackvalue = black[i];
		pixelvalue = rgb[i];
		uppervalue = whitevalue - blackvalue;
		rate = 255 / uppervalue;
		rgb[i] = minmax(0, (int)((pixelvalue - blackvalue) * rate), 255);
	}
	return rgb;
}
int main()
{
	int width = 352;
	int height = 288;
	int pause = 0;

	camera_t* camera = camera_open("/dev/video0", width, height);
	camera_init(camera);
	camera_start(camera);

	struct timeval timeout;
	timeout.tv_sec = 1;
	timeout.tv_usec = 0;

	/* skip 5 frames for booting a cam */
	for (int i = 0; i < 50; i++) camera_frame(camera, timeout);
  
	unsigned char* rgb, rgb_simple;
	uint8_t* black = calloc(width * 3, sizeof (uint8_t));
	uint8_t* white = calloc(width * 3, sizeof (uint8_t));
	uint8_t* baseline = calloc(width * 3, sizeof (uint8_t));

	vga_led_arg_t vla;
	int i, display_row, captureline = 0, captureline_1 = 0, captureline_2 = 0, blackline = 0, whiteline = 0;
	int mode_select;

	static const char filename[] = "/dev/vga_led";
	static unsigned char message[1063];

	int charcount = 0, stringcount = 0, stringnum = 0, backcharcount = 0, backstringcount = 0;
	char ch;
	char songtimechar[3];
	int songtime = 0, backsongtime = 0;
	char string[2];
        int songstring[100];
	int backsongstring[60];

	int screen_pressed[6];
	for (i = 0; i < 6; i++) {
		screen_pressed[i] = 0;
	}

	uint8_t* finger_position = calloc(6, sizeof (uint8_t));

	if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
		fprintf(stderr, "could not open %s\n", filename);
		return -1;
	}

	FILE *play_song; 
	play_song = fopen("mo_li_hua.txt", "r"); 

	charcount = 0;
	ch = fgetc(play_song);
	while (ch != ' ') {	
		songtimechar[charcount] = ch;
		charcount += 1;
                ch = fgetc(play_song);
	}
	backsongtime = atoi(songtimechar);

	stringcount = 0;

	while (ch != '\n') {	
		charcount = 0;
		ch = fgetc(play_song);
		while (ch != ' ' && ch != '\n') {	
			string[charcount] = ch;
			charcount += 1;
                        ch = fgetc(play_song);
		}
		backsongstring[stringcount] = atoi(string);
		stringcount += 1;
	}

	fclose(play_song);
	stringcount = 0;
	charcount = 0;


	rgb = yuyv2rgb(camera->head.start, camera->width, camera->height);
	baseline = disrgb(rgb, camera->width, camera->height);

	mode_select = 0;
	while (1) {

		pause = 0;

		if (mode_select == 0)
		{
			while (1) {
				camera_frame(camera, timeout);
				rgb = yuyv2rgb(camera->head.start, camera->width, camera->height);
			
				baseline = disrgb(rgb, camera->width, camera->height);
				
				captureline = baseline[792] + baseline[793];
				blackline = baseline[794] + baseline[795];
				whiteline = baseline[796] + baseline[797];
				
				if ((captureline >= 114) && (captureline <= 209)) {
					finger_position = finger_detection(rgb, camera->width, camera->height, captureline);
					if (finger_position[2] == 1) {
						message[1058] = 2;
						screen_pressed[2] = 1;
					}
					else if ((finger_position[2] == 0) && (screen_pressed[2] == 1)) {
						message[1058] = 3;
						mode_select = 3;
						screen_pressed[2] = 0;
						write_segments(message);
						free(rgb);
						break;
					}
					else message[1058] = 1;
					//printf("%d\n", finger_position[2]);
				}
				else message[1058] = 0;
				
				display_row = width * 3;
				for (i = 0; i < display_row; i++) {
					message[i] = baseline[i];
				}
				message[1056] = baseline[792];
				message[1057] = baseline[793];
				write_segments(message);
				free(rgb);
			}
			printf("Screen Calibration finished.\n\n");
			continue;
		}
		else if (mode_select == 4) 
		{
			for (i = 0; i < 20; i++) camera_frame(camera, timeout);
			printf("Entry Color Calibration.\n");

			while (1) {
				camera_frame(camera, timeout);
				rgb = coloryuyv2rgb(camera->head.start, black, white, camera->width, captureline);

				finger_position = finger_detection(rgb, camera->width, camera->height, 0);

				for (i = 0; i < width * 3; i++) {
					message[i] = rgb[width * 3 - 1 - i];
				}

				if (finger_position[0] == 1) {
					message[1058] = 5;
					screen_pressed[0] = 1;
				}
				else if ((finger_position[0] == 0) && (screen_pressed[0] == 1)) {
					message[1058] = 3;
					mode_select = 3;
					screen_pressed[0] = 0;
					write_segments(message);
					free(rgb);
					break;
				}
				else if (finger_position[1] == 1) {
					message[1058] = 6;
					screen_pressed[1] = 1;
				}
				else if ((finger_position[1] == 0) && (screen_pressed[1] == 1)) {
					message[1058] = 3;
					mode_select = 6;
					screen_pressed[1] = 0;
					write_segments(message);
					free(rgb);
					break;
				}
				else if (finger_position[2] == 1) {
					message[1058] = 7;
					screen_pressed[2] = 1;
				}
				else if ((finger_position[2] == 0) && (screen_pressed[2] == 1)) {
					message[1058] = 4;
					mode_select = 4;
					screen_pressed[2] = 0;
					free(rgb);	
					printf("Denoise pixel.\n\n");
					break;
				}
				else if (finger_position[3] == 1) {
					message[1058] = 8;
					screen_pressed[3] = 1;
				}
				else if ((finger_position[3] == 0) && (screen_pressed[3] == 1)) {
					message[1058] = 4;
					mode_select = 4;
					screen_pressed[3] = 0;
					free(rgb);
					printf("Recognize keys.\n\n");
					break;
				}
				else if (finger_position[4] == 1) {
					message[1058] = 9;
					screen_pressed[4] = 1;
				}
				else if ((finger_position[4] == 0) && (screen_pressed[4] == 1)) {
					message[1058] = 10;
					mode_select = 10;
					screen_pressed[4] = 0;
					write_segments(message);
					free(rgb);
					printf("Color Calibration function select finished.\n\n");
					break;
				}
				
				write_segments(message);
				free(rgb);
			}
			continue;
		}
		else if (mode_select == 3) 
		{
			while (pause < 50)
			{
				pause += 1;
				camera_frame(camera, timeout);
				rgb = yuyv2rgb(camera->head.start, camera->width, camera->height);
			
				rgb = color(rgb, camera->width, camera->height, captureline, blackline, whiteline);
				
				display_row = captureline * 1056; 
				//display_row = blackline * 1056; 
				//display_row = whiteline * 1056; 
				for (i = display_row; i < display_row + 1056; i++) {
					message[i - display_row] = rgb[display_row + display_row + 1055 - i];
				}
				message[1058] = 3;
				write_segments(message);

				for (size_t i = 0; i < width * 3; i++)
				{
					black[i] = rgb[blackline * width * 3 + i];
					white[i] = rgb[whiteline * width * 3 + i];
				}
				free(rgb);
			}
			message[1058] = 4;
			mode_select = 4;
			write_segments(message);
			printf("Color Calibration finished.\n\n");
			continue;
		}
		else if (mode_select == 6) 
		{
			while (pause < 50)
			{
				pause += 1;
				camera_frame(camera, timeout);
				rgb = yuyv2rgb(camera->head.start, camera->width, camera->height);
				
				display_row = captureline * 1056; 
				for (i = display_row; i < display_row + 1056; i++) {
					message[i - display_row] = rgb[display_row + display_row + 1055 - i];
				}
				message[1058] = 3;
				write_segments(message);
				free(rgb);
			}
			message[1058] = 4;
			mode_select = 4;
			write_segments(message);
			printf("Display original pixel finished.\n\n");
			continue;
		}
		else if (mode_select == 10) 
		{
			for (i = 0; i < 20; i++) camera_frame(camera, timeout);
			printf("Entry Welcome page.\n");
			while (1) 
			{
				camera_frame(camera, timeout);
				//rgb = yuyv2rgb(camera->head.start, camera->width, camera->height);
				rgb = coloryuyv2rgb(camera->head.start, black, white, camera->width, captureline);

				finger_position = finger_detection(rgb, camera->width, camera->height, 0);

				for (i = 0; i < width * 3; i++) {
					message[i] = rgb[width * 3 - 1 - i];
				}

				if (finger_position[0] == 1) {
					message[1058] = 11;
					message[1059] = 0;
					screen_pressed[0] = 1;
				}
				else if ((finger_position[0] == 0) && (screen_pressed[0] == 1)) {
					message[1058] = 16;
					message[1059] = 0;
					mode_select = 16;
					screen_pressed[0] = 0;
					write_segments(message);
					free(rgb);
					printf("Entry to the freedom mode.\n\n");
					break;
				}
				else if (finger_position[1] == 1) {
					message[1058] = 12;
					message[1059] = 0;
					write_segments(message);

					for (i = 0; i < 100; i++) {
						songstring[i] = -1;
					}

					FILE *play_song; 
					while (1) {	
						char inputfile[50];
						printf("Welcome to audio player mode.\n");
						printf("You can choose any song in below list or type your defined song file.\n*\n");
						printf("mo_li_hua.txt\n");
						printf("my_heart.txt\n");
						printf("littlestar.txt\n");
						printf("let_it_go.txt\n");
						printf("\nPlease type the song file name: ");
						scanf("%s", inputfile);
						printf("Song file: %s\n", inputfile);
						play_song = fopen(inputfile, "r"); 
						if (play_song != NULL) break;
		                        }

					charcount = 0;
					ch = fgetc(play_song);
					while (ch != ' ') {	
						songtimechar[charcount] = ch;
						charcount += 1;
		                                ch = fgetc(play_song);
					}
					songtime = atoi(songtimechar);

					stringcount = 0;

					while (ch != '\n') {	
						charcount = 0;
						ch = fgetc(play_song);
						while (ch != ' ' && ch != '\n') {	
							string[charcount] = ch;
							charcount += 1;
			                                ch = fgetc(play_song);
						}
						songstring[stringcount] = atoi(string);
						stringcount += 1;
					}

					fclose(play_song);
					printf("Song time is: %d\n", songtime);
					printf("Test string is: ");
					stringnum = 0;
					while (songstring[stringnum] != -1) {
						printf("%d ", songstring[stringnum]);
						stringnum += 1;
					}
					printf("\n");

					stringcount = 0;
					charcount = 0;

					message[1058] = 18;
					mode_select = 18;
					write_segments(message);
					free(rgb);
					printf("Entry to the Song player mode.\n\n");
					break;
				}
				else if (finger_position[2] == 1) {
					message[1058] = 13;
					message[1059] = 0;
					screen_pressed[2] = 1;
				}
				else if ((finger_position[2] == 0) && (screen_pressed[2] == 1)) {
					message[1058] = 20;
					message[1059] = 0;
					mode_select = 20;
					screen_pressed[2] = 0;
					write_segments(message);
					free(rgb);
					printf("Exit.\n\n");
					break;
				}
				else if (finger_position[3] == 1) {
					message[1058] = 14;
					screen_pressed[3] = 1;
				}
				else if ((finger_position[3] == 0) && (screen_pressed[3] == 1)) {
					message[1058] = 0;
					mode_select = 0;
					screen_pressed[3] = 0;
					write_segments(message);
					free(rgb);
					printf("Entry to the Screen Calibration mode.\n\n");
					break;
				}
				else if (finger_position[4] == 1) {
					message[1058] = 15;
					screen_pressed[4] = 1;
				}
				else if ((finger_position[4] == 0) && (screen_pressed[4] == 1)) {
					message[1058] = 4;
					mode_select = 4;
					screen_pressed[4] = 0;
					write_segments(message);
					free(rgb);
					printf("Entry to the Color Calibration mode.\n\n");
					break;
				}

				if (backcharcount < backsongtime / 2) {
					message[1059] = backsongstring[backstringcount];
					backcharcount += 1;
				}
				else if (backcharcount == backsongtime) {
					message[1059] = 0;
					backstringcount += 1;
					backcharcount = 0;
				}
				else {
					message[1059] = 0;
					backcharcount += 1;
				}

				if (backstringcount == 60) backstringcount = 0;
				write_segments(message);
				free(rgb);
			}
			continue;
		}
		else if (mode_select == 16) 
		{
			while (1)
			{
				camera_frame(camera, timeout);
			
				rgb = coloryuyv2rgb(camera->head.start, black, white, camera->width, captureline);
				
				finger_position = finger_detection(rgb, camera->width, camera->height, 0);

				if (finger_position[5] == 1) {
					message[1058] = 17;
					screen_pressed[5] = 1;
					write_segments(message);
				}
				else if ((finger_position[5] == 0) && (screen_pressed[5] == 1)) {
					message[1058] = 10;
					mode_select = 10;
					screen_pressed[5] = 0;
					write_segments(message);
					printf("Entry to the Welcome.\n\n");
					break;
				}
				else
				{
					message[1058] = 16;

					for (i = 0; i < width * 3; i++) {
						message[i] = rgb[width * 3 - 1 - i];
					}
					write_segments(message);
				}
				free(rgb);
			}
			message[1058] = 10;
			mode_select = 10;
			write_segments(message);
			printf("Free mode terminaled.\n\n");
			continue;
		}
		else if (mode_select == 18) 
		{
			
			while ((!kbhit()) && (stringcount < stringnum)) {
				camera_frame(camera, timeout);
				rgb = coloryuyv2rgb(camera->head.start, black, white, camera->width, captureline);

				finger_position = finger_detection(rgb, camera->width, camera->height, 0);

				if (finger_position[5] == 1) {
					message[1058] = 19;
					screen_pressed[5] = 1;
					write_segments(message);
				}
				else if ((finger_position[5] == 0) && (screen_pressed[5] == 1)) {
					message[1058] = 10;
					mode_select = 10;
					screen_pressed[5] = 0;
					write_segments(message);
					printf("Entry to the Welcome.\n\n");
					break;
				}
				else
				{
					for (i = 0; i < width * 3; i++) {
						message[i] = rgb[width * 3 - 1 - i];
					}

					if (charcount < songtime / 2) {
						message[1059] = songstring[stringcount];
						charcount += 1;
					}
					else if (charcount == songtime) {
						message[1059] = 0;
						stringcount += 1;
						charcount = 0;
					}
					else {
						message[1059] = 0;
						charcount += 1;
					}
					printf("%d %d\n", stringcount, charcount);
					write_segments(message);
				}
				free(rgb);
			}
			message[1058] = 10;
			mode_select = 10;
			write_segments(message);
			printf("Song Player mode terminaled.\n\n");
			continue;
		}
		else
		{
			printf("Program terminaled.\n");
			camera_stop(camera);
			camera_finish(camera);
			camera_close(camera);
			return 0;
		}
	}
}

